import scrollTo from 'utilities/dom/scrollTo';

interface IScrollContainerToNodeOptions {
    verticalPadding?: number;
    horizontal?: boolean;
    horizontalPadding?: number;
}

export default function scrollContainerToNode(
    container: HTMLElement,
    node: HTMLElement,
    {
        verticalPadding = 0,
        horizontal,
        horizontalPadding = 0,
    }: IScrollContainerToNodeOptions = {},
): void {
    const containerBox = container.getBoundingClientRect();
    const nodeBox = node.getBoundingClientRect();

    if (horizontal) {
        const {scrollLeft} = container;

        if (nodeBox.right > containerBox.right - horizontalPadding) {
            scrollTo(
                {
                    behavior: 'smooth',
                    left:
                        nodeBox.right -
                        containerBox.right +
                        scrollLeft +
                        horizontalPadding,
                },
                container,
            );
        } else if (nodeBox.left < containerBox.left + horizontalPadding) {
            scrollTo(
                {
                    behavior: 'smooth',
                    left:
                        scrollLeft -
                        containerBox.left +
                        nodeBox.left -
                        horizontalPadding,
                },
                container,
            );
        }
    } else {
        const {scrollTop} = container;

        if (nodeBox.bottom > containerBox.bottom - verticalPadding) {
            scrollTo(
                {
                    behavior: 'smooth',
                    top:
                        nodeBox.bottom -
                        containerBox.bottom +
                        scrollTop +
                        verticalPadding,
                },
                container,
            );
        } else if (nodeBox.top < containerBox.top + verticalPadding) {
            scrollTo(
                {
                    behavior: 'smooth',
                    top:
                        scrollTop -
                        containerBox.top +
                        nodeBox.top -
                        verticalPadding,
                },
                container,
            );
        }
    }
}
