import {AxiosError} from 'axios';

/**
 * Утилита для обработки ошибок в try/catch
 * - если тип Error то возвращаем как есть
 * - если тип undefined то возвращаем undefined
 * - иначе преобразуем в строку и запаковываем в Error
 * @param e неизвестная ошибка
 * @returns Error | undefined
 */
export function unknownToErrorOrUndefined(e: unknown): Error | undefined {
    if (e === undefined || e instanceof Error) {
        return e;
    }

    return new Error(String(e));
}

/**
 * Утилита для обработки ошибок в try/catch
 * - если тип Error то возвращаем как есть
 * - если тип undefined то возвращаем Error('Unknown error')
 * - иначе преобразуем в строку и запаковываем в Error
 * @param e неизвестная ошибка
 * @returns Error
 */
export function unknownToError(e: unknown): Error {
    if (e === undefined) {
        return new Error('Unknown error');
    }

    if (e instanceof Error) {
        return e;
    }

    return new Error(String(e));
}

/**
 * Утилита для обработки ошибок в try/catch
 * - если тип Error то возвращаем message
 * - иначе возвращаем преобразование в строку
 * @param e неизвестная ошибка
 * @returns string
 */
export function unknownErrToString(e: unknown): string {
    if (!e) {
        return '';
    }

    if (e instanceof Error) {
        return e.message;
    }

    return String(e);
}

export function isUnknownAxiosError<T = unknown>(
    e: unknown,
): e is AxiosError<T> {
    return Boolean((e as AxiosError)?.isAxiosError);
}
