/* eslint-disable no-bitwise */
// eslint-disable-next-line @typescript-eslint/naming-convention
export type Flag<T> = number & {__type: T};

export function createFlags<T>(init: number = 0): Flag<T> {
    return init as Flag<T>;
}

export function enable<T extends number>(flags: Flag<T>, flag: T): Flag<T> {
    return (flags | flag) as Flag<T>;
}

export function disable<T extends number>(flags: Flag<T>, flag: T): Flag<T> {
    return (flags & ~flag) as Flag<T>;
}

export function toggle<T extends number>(flags: Flag<T>, flag: T): Flag<T> {
    return (flags ^ flag) as Flag<T>;
}

export function isEnabled<T extends number>(flags: Flag<T>, flag: T): boolean {
    return (flags & flag) !== 0;
}

export function join<T extends number>(flags: Flag<T>[]): Flag<T> {
    let result = 0;
    for (const flag of flags) {
        result |= flag;
    }
    return result as Flag<T>;
}

export function toArray<T extends number>(flags: Flag<T>): T[] {
    const result: T[] = [];
    let i = 1;
    while (i <= flags) {
        if (isEnabled(flags, i)) {
            result.push(i as T);
        }
        i <<= 1;
    }
    return result;
}
