import {formatCountOfChildren} from 'utilities/formatCount';

import * as i18nBlock from 'i18nNew/hotels-BookPayPage';

export const formatChildrenAges = (
    childrenAges: number[],
): string | undefined => {
    const childrenCount = childrenAges.length;

    if (childrenCount === 0) {
        return;
    }

    let preparedChildrenAges: string;

    if (childrenCount === 1) {
        preparedChildrenAges = i18nBlock.age({count: childrenAges[0]});
    } else {
        preparedChildrenAges = childrenAges.reduce(
            (result: string, age, index) => {
                let currentResult = result;
                const isPenultimate = index + 2 === childrenCount;
                const isLast = index + 1 === childrenCount;

                switch (true) {
                    case isLast: {
                        currentResult += i18nBlock.age({count: age});

                        break;
                    }

                    case isPenultimate: {
                        currentResult += `${i18nBlock.age({
                            count: age,
                        })} ${i18nBlock.and()} `;

                        break;
                    }

                    default: {
                        currentResult += `${i18nBlock.age({count: age})}, `;
                    }
                }

                return currentResult;
            },
            '',
        );
    }

    const preparedChildrenCount = formatCountOfChildren(childrenCount);

    return `${preparedChildrenCount}: ${preparedChildrenAges}`;
};
