import {EGeoObjectType} from 'types/common/Geo';

export function getPointType(id?: string): EGeoObjectType {
    switch (id && id.charAt(0).toLowerCase()) {
        case EGeoObjectType.City:
            return EGeoObjectType.City;
        case EGeoObjectType.Station:
            return EGeoObjectType.Station;
        default:
            return EGeoObjectType.Unknown;
    }
}

export function isStation(id?: string): boolean {
    return getPointType(id) === EGeoObjectType.Station;
}

export function isCity(id?: string): boolean {
    return getPointType(id) === EGeoObjectType.City;
}
