import {ESortDirection} from 'types/common/sort/ESortDirection';
import {ESortType} from 'types/common/sort/ESortType';

import capitalizeFirstLetter from 'utilities/strings/capitalizeFirstLetter';

import * as i18nBlock from 'i18nNew/trains-search-sort';

export default function getSortDirectionLabel(
    type: ESortType,
    direction: ESortDirection,
): string {
    let label = '';

    switch (type) {
        case ESortType.ARRIVAL: {
            label =
                direction === ESortDirection.ASC
                    ? i18nBlock.sortDashDirectionDashArrivalDashAscending()
                    : i18nBlock.sortDashDirectionDashArrivalDashDescending();

            break;
        }
        case ESortType.DEPARTURE: {
            label =
                direction === ESortDirection.ASC
                    ? i18nBlock.sortDashDirectionDashDepartureDashAscending()
                    : i18nBlock.sortDashDirectionDashDepartureDashDescending();

            break;
        }
        case ESortType.DURATION: {
            label =
                direction === ESortDirection.ASC
                    ? i18nBlock.sortDashDirectionDashDurationDashAscending()
                    : i18nBlock.sortDashDirectionDashDurationDashDescending();

            break;
        }
        case ESortType.PRICE: {
            label =
                direction === ESortDirection.ASC
                    ? i18nBlock.sortDashDirectionDashPriceDashAscending()
                    : i18nBlock.sortDashDirectionDashPriceDashDescending();

            break;
        }
    }

    return capitalizeFirstLetter(label);
}
