import {ParsedQuery} from 'query-string';

import {IUtmQueryParams} from 'types/common/IQueryParams';

import {
    filterQueryByParamList,
    checkQueryStringParam,
} from 'utilities/location/filterQueryByParamList';
import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

/* Constants */
export const UTM_QUERY_PARAMS: (keyof IUtmQueryParams)[] = [
    'utm_source',
    'utm_medium',
    'utm_campaign',
    'utm_content',
    'utm_term',
];

/* Helpers */
export const getUtmQueryParamsByQuery = filterQueryByParamList<
    IUtmQueryParams,
    ParsedQuery
>(UTM_QUERY_PARAMS, checkQueryStringParam);

/**
 * Достает из query utm метки
 */
export const getUtmQueryParamsByBrowserHistory = (): IUtmQueryParams => {
    return getUtmQueryParamsByQuery(getQueryByBrowserHistory());
};
