import * as i18nBlock from 'i18nNew/common-greetingWithDayTime';

interface IDayInterval {
    start: number;
    end: number;
}

const night: IDayInterval = {
    start: 0,
    end: 5,
};

const morning: IDayInterval = {
    start: 6,
    end: 11,
};

const evening: IDayInterval = {
    start: 18,
    end: 23,
};

export function getGreetingWithDayTime(hours: number): string {
    if (isInInterval(hours, night)) {
        return i18nBlock.goodNight();
    } else if (isInInterval(hours, morning)) {
        return i18nBlock.goodMorning();
    } else if (isInInterval(hours, evening)) {
        return i18nBlock.goodEvening();
    }

    return i18nBlock.goodDay();
}

function isInInterval(hours: number, interval: IDayInterval): boolean {
    return hours >= interval.start && hours <= interval.end;
}
