import {useCallback} from 'react';

interface IUseFileSelectionDialog {
    openFileSelectionDialog: () => void;
}

export function useFileSelectionDialog(
    onFileSelected: (files: File[]) => void,
    dependencies: any[],
): IUseFileSelectionDialog {
    const openFileSelectionDialog = useCallback(() => {
        const input = document.createElement('input');

        input.type = 'file';
        input.accept = 'image/jpeg,image/png';
        input.multiple = true;

        input.onchange = (e: Event): void => {
            const target = e.target as HTMLInputElement;

            if (target?.files) {
                onFileSelected(Array.prototype.slice.call(target.files));
            }
        };

        input.click();
    }, dependencies);

    return {openFileSelectionDialog};
}
