import {useCallback, useEffect, useRef} from 'react';

import {useBoolean} from 'utilities/hooks/useBoolean';

export function useHoverEvents(delay = 400) {
    const {value, setTrue, setFalse} = useBoolean(false);
    const timerRef = useRef<number>();

    const clearTimeout = useCallback(() => {
        if (timerRef.current) {
            window.clearTimeout(timerRef.current);
        }
    }, [timerRef]);

    const handleMouseEnter = useCallback(() => {
        timerRef.current = window.setTimeout(setTrue, delay);
    }, [setTrue, delay]);

    const handleMouseLeave = useCallback(() => {
        clearTimeout();
        setFalse();
    }, [setFalse, clearTimeout]);

    useEffect(
        () => (): void => {
            clearTimeout();
        },
        [clearTimeout],
    );

    return {
        isHovered: value,
        handleMouseEnter,
        handleMouseLeave,
    };
}
