import {useState} from 'react';

import {useOnPageLoad} from 'utilities/hooks/useOnPageLoad';
import pageManager, {TPageLoadInfo} from 'utilities/pageManager/pageManager';

export const usePageLoadInfo = (): TPageLoadInfo => {
    const [pageLoadInfo, setPageLoadInfo] = useState<TPageLoadInfo>(
        pageManager.pageLoadInfo,
    );

    useOnPageLoad(setPageLoadInfo);

    return pageLoadInfo;
};
