import {useBoolean} from 'utilities/hooks/useBoolean';
import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

type TPrintOptions = import('print-js').Configuration;

// SSR escape
let printJs: typeof import('print-js') | undefined;

if (typeof window !== 'undefined') {
    printJs = require('print-js');
}

interface IPrintOptions extends TPrintOptions {}

interface IPrintInfo {
    isPrinting: boolean;
    startPrinting(): void;
}

export function usePrint(options: IPrintOptions): IPrintInfo {
    const {
        value: isPrinting,
        setTrue: startPrinting,
        setFalse: stopPrinting,
    } = useBoolean(false);

    return {
        isPrinting,
        startPrinting: useImmutableCallback(() => {
            startPrinting();
            printJs?.({
                ...options,
                onLoadingEnd: stopPrinting,
                onPdfOpen: stopPrinting,
                onError: stopPrinting,
            });
        }),
    };
}
