import React, {useCallback} from 'react';

/**
 * Бывают кейсы, когда при клике по элементу схлапывается какой-то контент сверху, из-за чего элемент,
 * по которому кликнули уезжает вверх и, особенно на мобильных устройствах, не понятно, что произошло.
 * Хочется, чтобы элемент, по которому кликнули, оставался под мышкой (пальцем).
 */
export default function useSaveElementPositionCallback(
    fn?: Function,
): (e: React.MouseEvent<HTMLElement>) => unknown {
    return useCallback(
        (e: React.MouseEvent<HTMLElement>) => {
            const elem = e.currentTarget as HTMLElement;
            const prevWindowScrollY = window.pageYOffset;
            const prevElementTop = elem.getBoundingClientRect().top;

            requestAnimationFrame(() => {
                const yDiff = elem.getBoundingClientRect().top - prevElementTop;

                if (yDiff) {
                    scrollTo({top: prevWindowScrollY + yDiff});
                }
            });

            fn?.();
        },
        [fn],
    );
}
