import {useSelector} from 'react-redux';

import {ESeoExpsCollection} from 'types/common/seoExps/ESeoExpsCollection';

import seoExpsSelector from 'selectors/common/seoExps';

export function useSeoExpsModifications(
    collection: ESeoExpsCollection,
): Record<string, string> {
    const {modifications} = useSelector(seoExpsSelector);

    return modifications
        .filter(item => item.collection === collection)
        .reduce(
            (acc, item) => ({
                ...acc,
                [item.element]: item.template,
            }),
            {},
        );
}
