import {useContext} from 'react';

import {
    ServerFetchDataContext,
    TServerFetchDataList,
} from 'contexts/ServerFetchDataContext';

export default function useServerDataFetcher(
    componentFetchList: TServerFetchDataList = [],
    {checkNested = false}: {checkNested?: boolean} = {},
): boolean {
    const serverFetchList = useContext(ServerFetchDataContext);

    if (!__SERVER__ || !serverFetchList) {
        return true;
    }

    serverFetchList.push(...componentFetchList);

    return checkNested;
}
