import {useEffect} from 'react';

import pageManager from 'utilities/pageManager/pageManager';
import {useBoolean} from 'utilities/hooks/useBoolean';

export const useWasNavigation = (): boolean => {
    const {value: wasNavigation, setTrue: setWasNavigation} = useBoolean(
        pageManager.wasNavigation,
    );

    useEffect(() => {
        if (!wasNavigation) {
            return pageManager.addOnFirstNavigationCallback(setWasNavigation);
        }
    }, [wasNavigation, setWasNavigation]);

    return wasNavigation;
};
