import {useState, useMemo} from 'react';
import {throttle} from 'lodash';

import {useEventListener} from './useEventListener';

interface IWindowLayout {
    width: number;
    height: number;
}

export function useWindowLayout(throttleMs?: number): IWindowLayout {
    const [layout, setLayout] = useState(getWindowLayout());

    const resizeCallback = useMemo(() => {
        const callback = (): void => setLayout(getWindowLayout);

        return throttleMs ? throttle(callback, throttleMs) : callback;
    }, [throttleMs]);

    useEventListener('resize', resizeCallback);

    return layout;
}

function getWindowLayout(): IWindowLayout {
    if (typeof window === 'undefined') {
        return {
            width: 0,
            height: 0,
        };
    }

    return {
        width: window.innerWidth,
        height: window.innerHeight,
    };
}
