import {useCallback, useEffect, useRef} from 'react';

import {SECOND} from 'utilities/dateUtils/constants';

import {getNow} from 'utilities/dateUtils';
import {useBoolean} from 'utilities/hooks/useBoolean';

const CHECK_TIMEOUT = 1000;
const EVENTS = ['mousemove', 'click', 'keypress'];

export function useInactivity(timeout: number = 15 * SECOND): boolean {
    const {value, setTrue} = useBoolean(false);
    const idleStart = useRef<number>(getNow());
    const timeoutRef = useRef<number>();

    const handleActivity = useCallback(() => {
        idleStart.current = getNow();
    }, []);

    useEffect(() => {
        EVENTS.forEach(event =>
            document.addEventListener(event, handleActivity),
        );

        (function checker(): void {
            if (getNow() - idleStart.current > timeout) {
                setTrue();
            } else {
                timeoutRef.current = window.setTimeout(checker, CHECK_TIMEOUT);
            }
        })();

        return (): void => {
            if (timeoutRef.current) {
                window.clearTimeout(timeoutRef.current);
            }

            EVENTS.forEach(event =>
                document.removeEventListener(event, handleActivity),
            );
        };
    }, [handleActivity, setTrue, timeout]);

    return value;
}
