import {logWarning} from 'utilities/logger/logWarning';

export default function hasWebPSupport(): boolean {
    if (__SERVER__) {
        return true;
    }

    const canvas = document.createElement('canvas');

    const hasSupport =
        Boolean(canvas.getContext?.('2d')) &&
        canvas.toDataURL('image/webp').indexOf('data:image/webp') === 0;

    if (!hasSupport) {
        logWarning({
            message: '[YATRAVEL][COMMON] нет поддержки webP',
        });
    }

    return hasSupport;
}
