import IIziTravelTourInfo from 'types/trips/IIziTravelTourInfo';

import {logError} from 'utilities/logger/logError';

import * as iziTravelTourType from 'i18nNew/happyPage_iziTravelTourType';

export default function getLocalizedTourCategory(
    tour: IIziTravelTourInfo,
): string {
    switch (tour.category) {
        case 'car':
            return iziTravelTourType.car();
        case 'walk':
            return iziTravelTourType.walk();

        default: {
            logError({
                message: `Неизвестная категория тура: ${tour.category} tour.type: ${tour.type}`,
                block: 'getLocalizedTourCategory',
            });

            return tour.category ?? tour.type;
        }
    }
}
