import * as localStorage from 'local-storage';
import _isObject from 'lodash/isObject';

import {EFormKey} from 'constants/form/EFormKey';
import {
    TRAVEL_STORAGE_KEY,
    BOOK_CONTACTS_KEY,
} from 'constants/storage/storageKeys';

import {TUserInfo} from 'reducers/common/commonReducerTypes';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';

import {TBookingContacts} from 'components/BookingContactsForm/BookingContactsForm';

import {IStorageContacts} from './saveBookingContacts';

const EMPTY_CONTACTS = {
    email: '',
    phone: '',
};

function formatPhoneNumber(phoneNumber?: string): string | undefined {
    if (phoneNumber?.startsWith('7')) {
        return `+${phoneNumber}`;
    }

    return undefined;
}

export function getBookingContacts<T extends TBookingContacts>(
    formKey: EFormKey,
    userInfo: TUserInfo,
): Partial<T> {
    const userUid = isAuthUser(userInfo) ? userInfo.uid : null;
    const userContacts = isAuthUser(userInfo)
        ? {
              email: userInfo.contacts?.email,
              phone: formatPhoneNumber(userInfo.contacts?.phones.phoneNumber),
          }
        : EMPTY_CONTACTS;
    const storageContacts: Nullable<IStorageContacts<T>> = localStorage.get(
        `${TRAVEL_STORAGE_KEY}/${BOOK_CONTACTS_KEY}/${formKey}`,
    );

    if (userUid !== storageContacts?.userUid) {
        return userContacts as Partial<T>;
    }

    if (_isObject(storageContacts)) {
        return {
            ...storageContacts.contacts,
            email: storageContacts.contacts.email || userContacts.email,
            phone: storageContacts.contacts.phone || userContacts.phone,
        };
    }

    return userContacts as Partial<T>;
}
