import * as localStorage from 'local-storage';

import {
    TRAVEL_STORAGE_KEY,
    BOOK_PASSENGERS_KEY,
} from 'constants/storage/storageKeys';

import {TUserInfo} from 'reducers/common/commonReducerTypes';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';

import {IFormDocument} from 'components/BookingPassengerForm/BookingPassengerForm';

import {IStoragePassengers} from './saveBookingPassengers';

/** Возвращает из localStorage значения пассажиров в форме бронирования */
export function getBookingPassengers<T extends IFormDocument = IFormDocument>(
    formKey: string,
    userInfo: TUserInfo,
): T[] {
    const userUid = isAuthUser(userInfo) ? userInfo.uid : null;
    const storagePassengers = localStorage.get<Nullable<IStoragePassengers<T>>>(
        `${TRAVEL_STORAGE_KEY}/${BOOK_PASSENGERS_KEY}/${formKey}`,
    );

    if (!storagePassengers) {
        return [];
    }

    const {passengers, userUid: storageUserUid} = storagePassengers;

    if (userUid === storageUserUid && passengers && Array.isArray(passengers)) {
        return passengers;
    }

    return [];
}
