import * as localStorage from 'local-storage';

import {
    TRAVEL_STORAGE_KEY,
    BOOK_PASSENGERS_KEY,
} from 'constants/storage/storageKeys';

import {TUserInfo} from 'reducers/common/commonReducerTypes';

import {IFormDocument} from 'components/BookingPassengerForm/BookingPassengerForm';

export interface IStoragePassengers<T extends IFormDocument> {
    passengers: T[];
    userUid: Nullable<string>;
}

/** Сохраняет информацию о пассажирах в бронировании. */
export function saveBookingPassengers<T extends IFormDocument = IFormDocument>(
    formKey: string,
    passengers: T[],
    userInfo: TUserInfo,
): void {
    const userUid = ('uid' in userInfo && userInfo.uid) || null;

    localStorage.set<IStoragePassengers<T>>(
        `${TRAVEL_STORAGE_KEY}/${BOOK_PASSENGERS_KEY}/${formKey}`,
        {
            passengers,
            userUid,
        },
    );
}
