import {unknownToErrorOrUndefined} from '../error';

export function logError(
    options: Omit<IRumErrorOptions, 'level' | 'service'>,
    error?: Error | unknown,
): void {
    try {
        window.Ya.Rum.logError(
            {
                ...options,
                service: 'front.portal',
                level: window.Ya.Rum.ERROR_LEVEL.ERROR,
            },
            unknownToErrorOrUndefined(error),
        );
    } catch {}
}
