import {
    ECommerceActionType,
    ICommerceActionField,
    ICommerceProduct,
} from 'utilities/metrika/types/ecommerce';

import {CurrencyType} from 'utilities/currency/CurrencyType';

/**
 * @see https://yandex.ru/support/metrika/data/e-commerce.html
 *
 * @param {ECommerceActionType} actionType - Название поля представляет собой идентификатор действия,
 * произведенного с набором товаров.
 * @param {Array<ICommerceProduct>} products - Список описаний товаров, с которыми было произведено указанное действие.
 * @param {ICommerceActionField} [actionField] - Дополнительные данные, описывающие произведенное действие.
 * Обрабатывается, только если действие — покупка (purchase).
 * @returns {void}
 */
export function eCommercePush(
    actionType: ECommerceActionType,
    products: ICommerceProduct[],
    actionField?: ICommerceActionField,
): void {
    if (typeof window === 'undefined') {
        return;
    }

    window.dataLayer = window.dataLayer || [];

    const data: {
        products: ICommerceProduct[];
        actionField?: ICommerceActionField;
    } = {
        products,
    };

    if (actionField) {
        data.actionField = actionField;
    }

    window.dataLayer.push({
        ecommerce: {
            currencyCode: CurrencyType.RUB,
            [actionType]: data,
        },
    });
}
