import {reachGoal} from 'utilities/metrika';

const METRIKA_PREFIX = /^(m__)([\w-]+)$/;

/**
 * Отсылаем в метрику события из параметров запроса
 * @param {Object} query - параметры запроса
 * @return {void}
 */
export default function handleMetrikaQuery(query) {
    Object.keys(query)
        .filter(key => METRIKA_PREFIX.test(key))
        .map(key => reachGoal(METRIKA_PREFIX.exec(key)[2]));
}
