import {TMetrikaGoal} from 'utilities/metrika/types/goals/all';
import {TMetrikaParams} from 'utilities/metrika/types/params/all';

const uniqGoals = new Set();

function addToQueue(item: TMetrikaQueueItem) {
    if (typeof window === 'undefined') {
        return;
    }

    if (typeof window.yaCounter50912507Queue === 'undefined') {
        window.yaCounter50912507Queue = [];
    }

    window.yaCounter50912507Queue.push(item);
}

export function reachGoal(
    target: TMetrikaGoal,
    ...args: TMetrikaParams[]
): void {
    if (typeof window === 'undefined') {
        return;
    }

    setTimeout(() => {
        if (window.yaCounter50912507) {
            window.yaCounter50912507.reachGoal(target, ...args);
        } else {
            addToQueue({
                target,
                props: args,
            });
        }
    });
}

export function reachGoalOnce(
    target: TMetrikaGoal,
    ...args: TMetrikaParams[]
): void {
    if (typeof window === 'undefined') {
        return;
    }

    if (!uniqGoals.has(target)) {
        uniqGoals.add(target);
        reachGoal(target, ...args);
    }
}

export function params(...args: TMetrikaParams[]): void {
    if (typeof window === 'undefined') {
        return;
    }

    setTimeout(() => {
        if (window.yaCounter50912507) {
            window.yaCounter50912507.params(...args);
        } else {
            addToQueue({
                props: args,
            });
        }
    });
}

export function userParams(...args: IMetrikaParams[]): void {
    if (typeof window === 'undefined') {
        return;
    }

    setTimeout(() => {
        if (window.yaCounter50912507) {
            window.yaCounter50912507.userParams(...args);
        } else {
            addToQueue({
                user: true,
                props: args,
            });
        }
    });
}

export function clearUniqGoals(): void {
    uniqGoals.clear();
}

export function hit(url: string, options: IMetrikaHitOptions = {}): void {
    const callback = () => {
        clearUniqGoals();

        if (options.callback) {
            options.callback.apply(options.ctx);
        }
    };

    setTimeout(() => {
        if (typeof window !== 'undefined' && window.yaCounter50912507) {
            window.yaCounter50912507.hit(url, {
                ...options,
                callback,
            });
        } else {
            callback();
        }
    });
}
