import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

import {EBannerColor} from 'components/CountryRestrictions/utilities/getBannerPreviewProperties';

export interface IMetrikaAviaBadPartnersParams {
    badPartners: Record<string, boolean>;
}

export interface IMetrikaAviaInvalidSearchParams {
    invalidSearchParams: Partial<IAviaParams>;
}

export interface IMetrikaAviaCovidBanner {
    covidBannerColor: EBannerColor;
}

interface IMetrikaAviaTariffWithFreeRefundRatioParams {
    tariffWithFreeRefundRatio: number;
}

interface IMetrikaAviaTariffWithChargedRefundRatioParams {
    tariffWithChargedRefundRatio: number;
}

interface IMetrikaAviaBookingParams {
    withPaymentErrorModal: number;
}

export type TGoalRefundValue = 'free' | 'charged' | 'no' | 'unknown';
export type TGoalBaggageValue = 'yes' | 'no';

export interface IMetrikaAviaTariffChoose {
    baggage: TGoalBaggageValue;
    refund: TGoalRefundValue;
}

export interface IMetrikaAviaTariffClick {
    count: number;
}

export type TMetrikaAviaParams =
    | IMetrikaAviaBadPartnersParams
    | IMetrikaAviaInvalidSearchParams
    | IMetrikaAviaCovidBanner
    | IMetrikaAviaTariffWithFreeRefundRatioParams
    | IMetrikaAviaTariffWithChargedRefundRatioParams
    | IMetrikaAviaTariffChoose
    | IMetrikaAviaTariffClick
    | IMetrikaAviaBookingParams;
