import {EProjectName} from 'constants/common';

import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';

import {FeaturesState} from 'reducers/common/commonReducerTypes';

export type TMetrikaCommonParams =
    | IMetrikaCommonSubscriptionsParams
    | IMetrikaCommonProjectNameParams
    | IMetrikaCommonFeaturesParams
    | IMetrikaCommonIntlSupportParams
    | IMetrikaCommonCertificateParams;

export interface IMetrikaCommonSubscriptionsParams {
    common: {
        subscriptions: {
            source: ESubscriptionSource;
            vertical: ESubscriptionVerticalName;
        };
    };
}

export interface IMetrikaCommonProjectNameParams {
    project: EProjectName;
}

export interface IMetrikaCommonFeaturesParams {
    features: FeaturesState;
    common: {
        userLoggedIn: boolean;
    };
}

interface IMetrikaCommonIntlSupportParams {
    common: {
        intlSupport: string;
    };
}

interface IMetrikaCommonCertificateParams {
    common: {
        headerCertificateClick?: boolean;
        sideSheetCertificateClick?: boolean;
    };
}
