import {useCallback} from 'react';

import {TMetrikaGoal} from 'utilities/metrika/types/goals/all';
import {TMetrikaParams} from 'utilities/metrika/types/params/all';

import {reachGoal} from '.';

export const useReachGoal = (
    target?: TMetrikaGoal,
    args?: TMetrikaParams[],
): (() => void) => {
    return useCallback(() => {
        if (target) {
            if (args) {
                reachGoal(target, ...args);
            } else {
                reachGoal(target);
            }
        }
    }, [target, args]);
};
