export enum ENumberLocale {
    RU = 'ru',
}

const LOCALE_DELIMITER: Record<ENumberLocale, string> = {
    [ENumberLocale.RU]: ',',
};

export function localeFormatFloat(
    value: number,
    locale?: ENumberLocale,
): string {
    return locale && LOCALE_DELIMITER[locale]
        ? value.toString().replace('.', LOCALE_DELIMITER[locale])
        : value.toLocaleString();
}
