import baseLoadable, {DefaultComponent} from '@loadable/component';

import PageLoading from 'components/PageLoading/PageLoading';

/**
 * NOTE: The detection of a loadable component is based on the keyword "loadable",
 * you have to name it loadable. Otherwise the code will not be transformed by the babel plugin
 * https://www.smooth-code.com/open-source/loadable-components/docs/babel-plugin/
 */
export function loadable<T>(func: (props: T) => Promise<DefaultComponent<T>>) {
    return baseLoadable(func, {fallback: <PageLoading />});
}
