import axios from 'axios';
import toSnakeCase from 'lodash/snakeCase';
import moment from 'moment';

import {BASE_AXIOS_HEADERS} from 'constants/axios';

import {ROBOT, HUMAN_DATE_RU} from 'utilities/dateUtils/formats';
import {csrf} from 'utilities/csrfToken/createGlobalTokenGetter';

function createAxios() {
    return axios.create({
        baseURL: '/api/account',
        headers: {
            ...BASE_AXIOS_HEADERS,
            ...csrf.tokenHeader,
        },
    });
}

const prepareData = data => {
    const result = {};
    Object.keys(data).forEach(key => {
        if (key === 'expirationDate' || key === 'birthDate') {
            if (data[key] === '') {
                result[toSnakeCase(key)] = null;
            } else {
                result[toSnakeCase(key)] = moment(
                    data[key],
                    HUMAN_DATE_RU,
                ).format(ROBOT);
            }
        } else if (
            ['itn', 'email', 'phone', 'phone_additional'].includes(key)
        ) {
            result[toSnakeCase(key)] = data[key] || null;
        } else if (key === 'train_notifications_enabled') {
            result[toSnakeCase(key)] = Boolean(data[key]);
        } else {
            result[toSnakeCase(key)] = data[key];
        }
    });
    return result;
};

export const fetchTraveller = () => createAxios().get('/travellerGet');

export const fetchPassengers = () => createAxios().get('/passengersGet');

export const addDocument = data =>
    createAxios().post('/documentAdd', {...prepareData(data)});

export const editDocument = data =>
    createAxios().put('/documentEdit', {...prepareData(data)});

export const removeDocument = data =>
    createAxios().delete('/documentRemove', {data: prepareData(data)});

// ADDITION OF PASSENGER
export const addPassenger = async data => {
    const res = [];
    const result = await createAxios().post('/passengerAdd', {
        ...prepareData(data.passenger),
    });

    res.push(result.data);
    data.document.passengerId = result.data.id;
    const docResult = await addDocument(data.document);
    res.push(docResult.data);
    return res;
};

export const editPassenger = data =>
    createAxios().put('/passengerEdit', {...prepareData(data)});

export const removePassenger = id =>
    createAxios().delete('/passengerRemove', {data: {id}});

export const fetchDocumentTypes = () => createAxios().get('/docTypesGet');
