import IPrice from 'utilities/currency/PriceInterface';

/**
 * Складывает цены
 * @exception если разные валюты, то кидает исключение
 */
export default function sumPrice(...prices: IPrice[]): IPrice {
    return prices.reduce((acc, price) => {
        if (acc.currency !== price.currency) {
            throw new Error(
                `Can't add price with different currencies: ${acc.currency} and ${price.currency}`,
            );
        }

        return {
            value: acc.value + price.value,
            currency: acc.currency,
        };
    });
}
