let isFinalized = false;

const initPage =
    typeof window === 'undefined' ? null : window.location.pathname;

/**
 * В SPA нужно вручную отправлять CLS и LCP
 *
 * Также сбрасываем rum_id и page, т.к. дальнейшие замеры при SPA переходах нас не интересуют.
 *
 * Pathname может остаться тем же, например,
 * если открылся модал с поддержкой закрытия по браузерному назад.
 *
 * @see https://a.yandex-team.ru/arcadia/frontend/packages/rum-counter#rum-i-spa
 */
export default function finalizeRumScores(): void {
    if (
        isFinalized ||
        !window?.Ya?.Rum ||
        window.location.pathname === initPage
    ) {
        return;
    }

    window.Ya.Rum.sendTrafficData();
    window.Ya.Rum.finalizeLayoutShiftScore();
    window.Ya.Rum.finalizeLargestContentfulPaint();

    /**
     * timeout, чтобы при переходе на другую страницу, сначала отправились данные по FID.
     */
    setTimeout(() => {
        window.Ya.Rum.setVars({
            rum_id: undefined,
            '-page': undefined,
        });
    }, 3000);

    isFinalized = true;
}
