import moment from 'moment';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {formatDate, getNow} from 'utilities/dateUtils';
import isSpecialWhen from 'utilities/dateUtils/when/isSpecialWhen';
import getWhenSpecialValueText from 'utilities/dateUtils/when/getWhenSpecialValueText';

import * as i18nSearchInformationBlock from 'i18nNew/trains-search-information';

/**
 * Функция возвращает отображаемое в схлопунтой форме значение даты выезда.
 */
export default function getSearchInformationHumanStartDate(
    date: undefined | null | boolean | string | WHEN_SPECIAL_VALUE,
): string {
    if (!date || typeof date === 'boolean') {
        return i18nSearchInformationBlock.periodDashPlaceholder();
    }

    if (isSpecialWhen(date)) {
        return getWhenSpecialValueText(date);
    }

    const whenMoment = moment(date);
    const isSameYear = moment(getNow()).isSame(whenMoment, 'year');

    return formatDate(
        whenMoment,
        isSameYear
            ? i18nSearchInformationBlock.periodDashFormat()
            : i18nSearchInformationBlock.periodDashFullDashFormat(),
    );
}
