import {ComponentType} from 'react';

import {EProjectName} from 'constants/common';

import {IIconProps} from 'icons/types/icon';
import {TTransportProjectName} from 'types/common/TTransportProjectName';

import BusIcon from 'icons/16/Bus';
import PlaneIcon from 'icons/16/Plane';
import TrainIcon from 'icons/16/Train';

export const getTransportIcon = (
    vertical: TTransportProjectName,
): ComponentType<IIconProps> | undefined => {
    switch (vertical) {
        case EProjectName.AVIA:
            return PlaneIcon;
        case EProjectName.BUSES:
            return BusIcon;
        case EProjectName.TRAINS:
            return TrainIcon;
    }
};
