import {BASE_COMMON_API_URL, SOLOMON_API_PATH} from 'constants/common';
import {ESolomonSensorType, PAYMENT_LABEL} from 'server/constants/solomon';

import {logError} from 'utilities/logger/logError';
import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

interface ISolomonPushData {
    sensor: string;
    name: string;
    labels: any;
    value?: any;
}

class SolomonBrowserHttpClient extends BrowserHttpClient {
    constructor() {
        super({baseURL: BASE_COMMON_API_URL});
    }

    push(data: ISolomonPushData): Promise<unknown> {
        return this.post(SOLOMON_API_PATH, data).catch(e => {
            logError(
                {
                    message: '[YATRAVEL] Solomon push error',
                    additional: {
                        ...data,
                    },
                },
                e,
            );
        });
    }
}

type TSolomonSender<Value> = (name: string, value?: Value) => void;

function createSolomonSender<Value, Labels = unknown>(
    sensor: ESolomonSensorType,
    labels?: Labels,
): TSolomonSender<Value> {
    return (name: string, value?: Value): Promise<unknown> => {
        const client = new SolomonBrowserHttpClient();
        const data = {
            sensor,
            name,
            labels,
            value,
        };

        return client.push(data);
    };
}

export const sendPaymentCounter = createSolomonSender(
    ESolomonSensorType.COUNTER,
    {
        type: PAYMENT_LABEL,
    },
);

export const sendCounter = createSolomonSender(ESolomonSensorType.COUNTER);
export const sendGauge = createSolomonSender(ESolomonSensorType.GAUGE);
export const sendRate = createSolomonSender(ESolomonSensorType.RATE);
