import * as i18nBlock from 'i18nNew/common-word-links';

/**
 * Функция возвращает список, разделенный запятыми с пробелом и союзом "и" перед последним элеменом
 * Пример: ['сова', 'волк', 'заяц'] -> 'сова, волк и заяц'
 *
 * @param strings — список, который надо "склеить"
 */
export function humanList(strings: (string | number)[]): string {
    if (strings.length <= 1) {
        return String(strings[0]);
    }

    const lastIndex = strings.length - 1;

    return [strings.slice(0, lastIndex).join(', '), strings[lastIndex]].join(
        ` ${i18nBlock.and()} `,
    );
}
