/**
 * Транслит кириллицы в латиницу (соответствует официальному см. https://www.gosuslugi.ru/help/faq/foreign_passport/100359)
 * а → a, б → b, в → v, г → g, д → d, е → e, ё → e, ж → zh, з → z, и → i, й → i, к → k, л → l, м → m, н → n, о → o, п → p, р → r, с → s, т → t, у → u, ф → f, х → кh, ц → ts, ч → сh, ш → sh, щ → shch, ы → y, ъ → ie, э → e, ю → iu, я → ia
 */
const LETTERS_MAP: Record<string, string | undefined> = {
    А: 'A',
    Б: 'B',
    В: 'V',
    Г: 'G',
    Д: 'D',
    Е: 'E',
    Ё: 'E',
    Ж: 'Zh',
    З: 'Z',
    И: 'I',
    Й: 'I',
    К: 'K',
    Л: 'L',
    М: 'M',
    Н: 'N',
    О: 'O',
    П: 'P',
    Р: 'R',
    С: 'S',
    Т: 'T',
    У: 'U',
    Ф: 'F',
    Х: 'Kh',
    Ц: 'Ts',
    Ч: 'Ch',
    Ш: 'Sh',
    Щ: 'Shch',
    Ъ: 'Ie',
    Ы: 'Y',
    Ь: '',
    Э: 'E',
    Ю: 'Iu',
    Я: 'Ia',
    а: 'a',
    б: 'b',
    в: 'v',
    г: 'g',
    д: 'd',
    е: 'e',
    ё: 'e',
    ж: 'zh',
    з: 'z',
    и: 'i',
    й: 'i',
    к: 'k',
    л: 'l',
    м: 'm',
    н: 'n',
    о: 'o',
    п: 'p',
    р: 'r',
    с: 's',
    т: 't',
    у: 'u',
    ф: 'f',
    х: 'kh',
    ц: 'ts',
    ч: 'ch',
    ш: 'sh',
    щ: 'shch',
    ъ: 'ie',
    ы: 'y',
    ь: '',
    э: 'e',
    ю: 'iu',
    я: 'ia',
};

export function translate(word: string): string {
    return word
        .split('')
        .map(char => (char in LETTERS_MAP ? LETTERS_MAP[char] : char))
        .join('');
}
