// Функция выполняет подстановки в строках вида "... [[#tag_name#Значение по умолчанию для тэга]] ..."
export function templateReplacement(
    template: string,
    replacement?: Record<string, string>,
): string {
    return template.replace(
        /\[\[#(\w*)#([^\]]*)]]/g,
        (match, key, defaultValue) => replacement?.[key] || defaultValue,
    );
}
