import {parse, stringify} from 'query-string';

import {IUrlQuery} from './types';

export const appendQueryParams = (url: string, params: IUrlQuery): string => {
    try {
        if (typeof URL === 'undefined') {
            return oldBrowsersAppendQueryParam(url, params);
        }

        const urlObject = new URL(url);

        urlObject.search = stringify({
            ...parse(urlObject.search),
            ...params,
        });

        return urlObject.toString();
    } catch (e) {
        return oldBrowsersAppendQueryParam(url, params);
    }
};

function oldBrowsersAppendQueryParam(url: string, params: IUrlQuery): string {
    const hashParts = url.split('#');
    const searchParts = hashParts[0].split('?');

    for (const param in params) {
        if (Object.prototype.hasOwnProperty.call(params, param)) {
            const queryParam = `${param}=${params[param]}`;

            if (searchParts.length === 1) {
                searchParts.push(queryParam);
            } else {
                searchParts[1] = `${searchParts[1]}&${queryParam}`;
            }
        }
    }

    hashParts[0] = searchParts.join('?');

    return hashParts.join('#');
}
