import Cookie from 'js-cookie';

import {PAYMENT_TEST_CONTEXT_TOKEN_COOKIE_NAME} from 'constants/testContext';

import appData from 'utilities/appData/appData';
import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

export function getPaymentTestContextToken(): string | undefined {
    if (appData.isProductionEnv) {
        return;
    }

    const {paymentTestContextToken} = getQueryByBrowserHistory();

    if (paymentTestContextToken) {
        return Array.isArray(paymentTestContextToken)
            ? paymentTestContextToken[0]
            : paymentTestContextToken;
    }

    return Cookie.get(PAYMENT_TEST_CONTEXT_TOKEN_COOKIE_NAME);
}
