import Cookie from 'js-cookie';

import {START_PAYMENT_TEST_CONTEXT_TOKEN_COOKIE_NAME} from 'constants/testContext';

import appData from 'utilities/appData/appData';
import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

export function getStartPaymentTestContextToken(): string | undefined {
    if (appData.isProductionEnv) {
        return;
    }

    const {startPaymentTestContextToken} = getQueryByBrowserHistory();

    if (startPaymentTestContextToken) {
        return Array.isArray(startPaymentTestContextToken)
            ? startPaymentTestContextToken[0]
            : startPaymentTestContextToken;
    }

    return Cookie.get(START_PAYMENT_TEST_CONTEXT_TOKEN_COOKIE_NAME);
}
