import {TExpressQuery} from 'types/TExpressQuery';

export function getStringValueFromQuery(
    query: TExpressQuery,
    nameParameter: Readonly<string | string[]>,
): string | undefined {
    const names =
        typeof nameParameter === 'string' ? [nameParameter] : nameParameter;

    for (const name of names) {
        const value = query[name];

        if (typeof value === 'string' && value) {
            return value;
        }
    }

    return undefined;
}
