import {parse, stringify} from 'query-string';

import {IUrlQuery} from 'utilities/url/types';

export default function getUrlWithUpdatedQuery(
    url: string,
    query: IUrlQuery,
): string {
    const [path, search] = url.split('?');

    const parsedQuery = parse(search);

    const updatedQuery = {
        ...parsedQuery,
        ...query,
    };

    const stringQuery = stringify(updatedQuery);

    return `${path}${stringQuery && `?${stringQuery}`}`;
}
