import {
    TDependentValue,
    TValidations,
    IFormValidationData,
} from 'types/common/validation/validation';

import rules from './rules/rules';

/**
 * Проверяет значение на соотвествие правилам
 *
 * @returns true - если значение, соответствует условию
 */
function checkDependentValue(
    value: any,
    valueRules: TDependentValue | TValidations | undefined,
    formData: IFormValidationData,
): boolean {
    if (valueRules) {
        for (let i = 0; i < valueRules.length; i++) {
            const rule = valueRules[i];
            const isValidValue = rules[rule.type](rule.params, value, formData);

            if (!isValidValue) {
                return false;
            }
        }
    }

    return true;
}

export default checkDependentValue;
