import moment from 'moment';

import {IDateOffset} from 'types/common/validation/validation';

import {DateLikeType, getNow} from 'utilities/dateUtils';
import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';
import getDateWithOffset from 'utilities/dateUtils/getDateWithOffset';

/**
 * Проверяет на минимальную дату относительно сегодня
 *
 * @param dateOffset - сдвиг даты
 * @param value - значение поля, в формате dd.mm.yyyy
 *
 * @returns true - если значение валидное
 */
export default function maxDateFromToday(
    dateOffset: IDateOffset,
    value?: DateLikeType,
): boolean {
    if (value) {
        const maxDate = getDateWithOffset(getNow(), dateOffset).startOf('date');
        const dateValue = moment(value, HUMAN_DATE_RU);

        return dateOffset.strict
            ? dateValue.isBefore(maxDate, dateOffset.comparisonScale)
            : dateValue.isSameOrBefore(maxDate, dateOffset.comparisonScale);
    }

    return true;
}
