import moment from 'moment';

import {DateLikeType} from 'utilities/dateUtils';
import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

/**
 * Проверяет что дата не раньше минимальной
 *
 * @param minDateValue - минимальная длина строки, в формате dd.mm.yyyy
 * @param value - значение поля, в формате dd.mm.yyyy
 *
 * @returns true - если значение валидное
 */
export default function minDate(
    minDateValue: DateLikeType,
    value?: DateLikeType,
): boolean {
    if (value) {
        const dateThreshold = moment(minDateValue, HUMAN_DATE_RU);
        const dateValue = moment(value, HUMAN_DATE_RU);

        return dateValue.isSameOrAfter(dateThreshold);
    }

    return true;
}
