/**
 * Проверяет поле на несоответвие значению из списка
 *
 * @param unavaliableValues - список допустимых значений
 * @param value - значение поля
 *
 * @returns true - если значение не встречается в списке
 */
type TSelectValue = string | boolean | number | null | undefined;

export default function notOneOf(
    unavaliableValues: TSelectValue[],
    value: TSelectValue,
): boolean {
    return !unavaliableValues.includes(value);
}
